unit uSetTutorArrange;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DBCtrls, dbcgrids, ExtCtrls, Menus, Mask, Grids,
  DBGrids, DB, DBTables;

type
  TSetTutorArrange = class(TForm)
    gClass: TDBCtrlGrid;
    DBText1: TDBText;
    gSubject: TDBCtrlGrid;
    DBText2: TDBText;
    gTeacher: TDBCtrlGrid;
    DBText3: TDBText;
    DBText4: TDBText;
    gRoom: TDBCtrlGrid;
    DBText5: TDBText;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    ClassTitle: TLabel;
    DBText6: TDBText;
    DBText7: TDBText;
    Shape1: TShape;
    paneTutor: TPanel;
    gTutorArrange: TDBCtrlGrid;
    DBText9: TDBText;
    txtTeacher: TDBText;
    Label1: TLabel;
    Shape6: TShape;
    DBText8: TDBText;
    Label2: TLabel;
    Label3: TLabel;
    btnClick: TShape;
    TimerClick: TTimer;
    Shape7: TShape;
    Shape8: TShape;
    txtNbr: TDBText;
    Label4: TLabel;
    DBText12: TDBText;
    TimerFont: TTimer;
    DBText10: TDBText;
    procedure FormActivate(Sender: TObject);
    procedure gSubjectClick(Sender: TObject);
    procedure gTeacherClick(Sender: TObject);
    procedure gRoomClick(Sender: TObject);
    procedure DBText8DblClick(Sender: TObject);
    procedure txtTeacherDblClick(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure Label3Click(Sender: TObject);
    procedure Label2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label2MouseLeave(Sender: TObject);
    procedure TimerClickTimer(Sender: TObject);
    procedure txtNbrMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TimerFontTimer(Sender: TObject);
  private
    { Private declarations }
    Leaving: boolean;
  public
    { Public declarations }
  end;

var
  SetTutorArrange: TSetTutorArrange;

implementation

uses udm, ufSetRoom, ufSetTeacher, ufSetClass;

{$R *.dfm}

procedure TSetTutorArrange.FormActivate(Sender: TObject);
begin
  Top    := 26;
  Left   := 0;
  Width  := 1024;
  Height := 768-26;
  Leaving := false;
end;

procedure TSetTutorArrange.gSubjectClick(Sender: TObject);
begin
  if not dm.tTutorArrange.Locate('ClassID; SubjID',
         VarArrayOf([dm.tClass.FieldByName('ID').AsString, dm.qSubject.FieldByName('ID').AsString]), []) then begin
    dm.tTutorArrange.Insert;
    dm.tTutorArrange.FieldByName('ClassID').AsString  := dm.tClass.FieldByName('ID').AsString;
    dm.tTutorArrange.FieldByName('SubjID').AsString   := dm.qSubject.FieldByName('ID').AsString;
    dm.tTutorArrange.FieldByName('SubjName').AsString := dm.qSubject.FieldByName('Name').AsString;
    dm.tTutorArrange.FieldByName('Nbr').AsInteger     := dm.tClass.FieldByName(dm.tTutorArrange.FieldByName('SubjName').AsString).AsInteger;
    dm.tTutorArrange.FieldByName('SchYear').AsInteger := vSchYear;
    dm.tTutorArrange.Post;
  end;
end;

procedure TSetTutorArrange.gTeacherClick(Sender: TObject);
begin
  if dm.tTutorArrange.FieldByName('TchrID').AsString = ''
  then begin
    dm.tTutorArrange.edit;
    dm.tTutorArrange.FieldByName('TchrID').AsString  := dm.tTeacher.FieldByName('id').AsString;
    dm.tTutorArrange.Post;
    TimerFont.Interval := 250;
    txtTeacher.Font.Color := clBlue;
    TimerFont.Enabled  := true;
  end;
end;

procedure TSetTutorArrange.gRoomClick(Sender: TObject);
begin
  dm.tTutorArrange.edit;
  dm.tTutorArrange.FieldByName('RoomID').AsString  := dm.qRoom.FieldByName('Code').AsString;
  dm.tTutorArrange.Post;
end;

procedure TSetTutorArrange.DBText8DblClick(Sender: TObject);
begin
  dm.tTutorArrange.edit;
  dm.tTutorArrange.FieldByName('RoomID').AsString  := '';
  dm.tTutorArrange.Post;
end;

procedure TSetTutorArrange.txtTeacherDblClick(Sender: TObject);
begin
{  dm.tTutorArrange.edit;
  dm.tTutorArrange.FieldByName('TchrID').AsString  := '';
  dm.tTutorArrange.Post;}
end;

procedure TSetTutorArrange.Label2Click(Sender: TObject);
var s:array [1..6] of variant;
    ss:variant;
    i:integer;
begin
  if MessageDlg('Confirm delete record?', mtError, mbOkCancel, 0) = mrOk then begin
    btnClick.Left      := TLabel(Sender).Left - 1;
    btnClick.Top       := TLabel(Sender).Top  - 1;
    btnClick.Height    := TLabel(Sender).Height + 2;
    btnClick.Width     := TLabel(Sender).Width  + 2;
    btnClick.Visible   := true;
    TimerClick.Enabled := true;
    for i := 1 to dm.tTutorArrange.FieldByName('Nbr').AsInteger do begin
      s[1] := dm.tTutorArrange.FieldByName('ClassID').AsString;
      s[2] := dm.tTutorArrange.FieldByName('Subj').AsString;
      s[3] := dm.tTutorArrange.FieldByName('TchrID').AsString;
      s[4] := dm.tTutorArrange.FieldByName('RoomID').AsString;
      s[5] := IntToStr(i);
      s[6] := vSchYear;
      ss   := VarArrayOf([S[1], S[2], S[3], S[4], S[5], S[6]]);
      if dm.tDetail.Locate('ClassCode; SubjectCode; TeacherID; RoomCode; Nbr; SchYear', ss, []) then begin { create Record }
        dm.tDetail.Delete;
      end;
    end;
    dm.tTutorArrange.Delete;
  end;
end;

procedure TSetTutorArrange.Label3Click(Sender: TObject);
begin
  btnClick.Left := TLabel(Sender).Left - 1;
  btnClick.Top  := TLabel(Sender).Top  - 1;
  btnClick.Height := TLabel(Sender).Height + 2;
  btnClick.Width  := TLabel(Sender).Width  + 2;
  btnClick.Visible := true;
  Leaving            := true;
  TimerClick.Enabled := true;
end;

procedure TSetTutorArrange.Label2MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  TLabel(Sender).Font.Color := clBlue;
end;

procedure TSetTutorArrange.Label2MouseLeave(Sender: TObject);
begin
  TLabel(Sender).Font.Color := clTeal;
end;

procedure TSetTutorArrange.TimerClickTimer(Sender: TObject);
begin
  btnClick.Visible   := false;
  TimerClick.Enabled := false;
  if Leaving then close;
end;

procedure TSetTutorArrange.txtNbrMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
{  case Button of
    mbRight : begin
               dm.tTutorArrange.edit;
               dm.tTutorArrange.FieldByName('Nbr').AsInteger  := dm.tTutorArrange.FieldByName('Nbr').AsInteger - 1;
               dm.tTutorArrange.Post;
             end;
    mbLeft : begin
               dm.tTutorArrange.edit;
               dm.tTutorArrange.FieldByName('Nbr').AsInteger  := dm.tTutorArrange.FieldByName('Nbr').AsInteger + 1;
               dm.tTutorArrange.Post;
             end;
  end;}
end;

procedure TSetTutorArrange.TimerFontTimer(Sender: TObject);
begin
  txtTeacher.Font.Color := clTeal;
  txtNbr.Font.Color     := clTeal;
  TimerFont.Enabled := false;
end;

end.
